#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12434);
 script_bugtraq_id(9027);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0859");
 name["english"] = "RHSA-2003-335: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the glibc package installed.

The glibc package provides the standard system libraries. This package
contains a flaw which may allow an attacker to perform a local denial
of service against the software tsing the getifaddrs() function, by
sending spoofed packets to the local netlink interface.

Solution : https://rhn.redhat.com/errata/RHSA-2003-334.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"glibc-", reference:"glibc-2.3.2-95.6", release:"RHEL3") )
	security_warning(0);
