#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12435);
 script_bugtraq_id(9138);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0542");
 name["english"] = "RHSA-2003-360: Apache";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the apache package installed.

The remote version of this software is vulnerable to a flaw in the way it
handles regular expressions in configuration files. To exploit this flaw,
an attacker needs to be able to write to an Apache configuration file
(ie: .htaccess or httpd.conf). By exploiting this flaw, a local attacker
could get the privileges of the user 'www'.

Solution : https://rhn.redhat.com/errata/RHSA-2003-360.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"apache-", reference:"apache-1.3.27-6.ent", yank:".ent", release:"RHEL2.1") )
	security_warning(0);
else if ( rpm_exists(rpm:"apache-", release:"RHEL2.1") ) set_kb_item(name:"CAN-2003-0542", value:TRUE);

