#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12436);
 script_bugtraq_id(9138);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2002-1565");
 name["english"] = "RHSA-2003-372: wget";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the wget package installed.

wget is a file retrieval utility which uses the HTTP and FTP protocols.

There is a buffer overflow in the url_filename function of wget 1.8.1 which
may let an attacker to cause a segmentation fault by supplying a long URL.

To exploit this flaw, an attacker would need to set up a rogue website 
containing very long links, and would need an attacker to mirror it using wget.

The Red Hat security team do not consider this issue can let an attacker 
run arbitrary code using this overflow.

Solution : https://rhn.redhat.com/errata/RHSA-2003-372.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wget package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"wget-1.8.2-14.72", release:"RHEL2.1") )
	security_warning(0);

