#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12437);
 script_bugtraq_id(9079);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0967");
 name["english"] = "RHSA-2003-386: FreeRADIUS";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the FreeRADIUS pacakge installed.

FreeRADIUS, an internet authentication deamon implementing the RADIUS protocol,
is vulnerable to a bug which may allow an attacker to cause a DoS of
the service remotely.

Solution : https://rhn.redhat.com/errata/RHSA-2003-386.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the FreeRadius package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(prefix:"freeradius", reference:"freeradius-0.9.3-1", release:"RHEL3") )
	security_hole(0);

