#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12438);
 script_bugtraq_id(9138);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0961");
 name["english"] = "RHSA-2003-389: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel installed.

The remote version of this kernel contains a bug in the do_brk() system call
which may let a local user to gain root privileges on the remote host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-389.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"kernel-", reference:"kernel-2.4.9-e.30",yank:"e.", release:"RHEL2.1") )
	security_hole(0);

