#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12439);
 script_bugtraq_id(9115);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0971");
 name["english"] = "RHSA-2003-395: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the GnuGPG package installed.

gnupg, a utility for encrypting data and creating digital signatures,
contain a severe bug in the way it generates and uses ElGamal keys when
they are used to both sign and encrypt data. An attacker may use this
flaw to recover the private key of the user.

This updated package from Red Hat disables the creation of ElGamal keys,
which therefore can not be miused any more. For more information,
please refer to the Red Hat security bulletin.


Solution : https://rhn.redhat.com/errata/RHSA-2003-395.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check(prefix:"gnupg-", reference:"gnupg-1.0.7-13", release:"RHEL2.1") ||
     rpm_check(prefix:"gnupg-", reference:"gnupg-1.2.1-10", release:"RHEL3") )
	security_warning(0);
