#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12440);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0962");
 name["english"] = "RHSA-2003-335: rsync";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the rsync package installed.

rsync, a program for synchronizing files over the network, is vulnerable
to a heap overflow which may allow an attacker to gain a shell on this
host, provided that rsync server is running on this host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-399.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rsync package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"rsync-2.5.7-0.7", release:"RHEL2.1") ||
     rpm_check(reference:"rsync-2.5.7-1", release:"RHEL3") )
	security_hole(0);
