#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12441);
 script_bugtraq_id(9210, 9212);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0963");
 name["english"] = "RHSA-2003-404: lftp";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the lftp package installed.

lftp, a command-line utility supporting FTP and HTTP protocols,
contain a buffer overflow which may allow an attacker to execute commands
on this host.

To exploit this flaw, an attacker would need to set up a rogue website
returning malformed replies to the 'ls' or 'rels' commands, and would
need to lure a user of this host into visiting it.

Solution : https://rhn.redhat.com/errata/RHSA-2003-404.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lftp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"lftp-2.4.9-2", release:"RHEL2.1") ||
     rpm_check(reference:"lftp-2.6.3-5", release:"RHEL3") )
	security_hole(0);

