#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12444);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0985");
 name["english"] = "RHSA-2003-419: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel installed.

There is a flaw in the mremap() function as it is being implemented by the
remote kernel, which may allow a local attacker to gain root or kernel-level
privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2003-419.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"kernel-", reference:"kernel-2.4.9-e.35",yank:"e.", release:"RHEL2.1") )
	security_hole(0);

