#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12446);
 script_bugtraq_id(4829);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2002-0844", "CAN-2003-0977");
 name["english"] = "RHSA-2004-004: cvs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the cvs package installed.

cvs is a version control system. There are various minor flaws in the remote
version of this software which may cause a CVS server to attempt to create
files or directories at the root level of the file system.

Solution : https://rhn.redhat.com/errata/RHSA-2004-004.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cvs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", reference:"cvs-1.11.1p1-9") || 
     rpm_check(release:"RHEL3",   reference:"cvs-1.11.2-14") ) security_warning(0);
