#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12447);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0988");
 name["english"] = "RHSA-2004-005: kdepim";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the kdepim package installed.

kdepim, a personal information management suite for the KDE graphical
desktop, contains a buffer overflow in the file information reader for
.vcf files, which may allow an attacker to execute arbitrary commands
on the remote host.

To exploit this flaw, an attacker would need to send a malformed .vcf
file to a user of the remote host and wait for him to process it using
kdepim.

Solution : https://rhn.redhat.com/errata/RHSA-2004-005.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdepim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", prefix:"kdepim-", reference:"kdepim-3.1.3-3.3") )
	security_hole(0);
