#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12448);
 script_bugtraq_id(9423);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0989", "CAN-2004-0055", "CAN-2004-0057");
 name["english"] = "RHSA-2004-009: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the tcpdump, libpcap and/or arpwatch 
packages installed.

These packages, which have to do with network sniffing, contain a bug
in the way they parse ISAKMP and RADIUS packets. A remote attacker
could exploit this issue by sending a specially malformed network packet
to the remote host, while a user is running one of these packages. As a result,
the attacker would be able to execute arbitrary code on the remote host,
as the 'pcap' user.

Solution : https://rhn.redhat.com/errata/RHSA-2004-008.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", reference:"tcpdump-3.6.2-12.2.1AS.5", yank:"AS") ||
     rpm_check(release:"RHEL2.1", reference:"libpcap-0.6.2-12.2.1AS.5", yank:"AS") ||
     rpm_check(release:"RHEL2.1", reference:"arpwatch-2.1a11-12.2.1AS.5", yank:"AS") ||
     rpm_check(release:"RHEL3",   reference:"tcpdump-3.7.2-7.E3.1", yank:"E") ||
     rpm_check(release:"RHEL3",   reference:"libpcap-0.7.2-7.E3.1", yank:"E"))
	security_hole(0);
