#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12449);
 script_bugtraq_id(9430);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0966");
 name["english"] = "RHSA-2004-009: elm";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the elm package installed.

ELM is a terminal mode email user agent. It provides the 'frm' command which
gives a summary of the sender and subject of a set of selected messages in
a mailbox or folder.

There is a buffer overflow vulnerability in the frm command which may allow
an attacker to execute arbitrary code on the remote host. To exploit this
flaw, an attacker would need to send a specially crafted message to a victim
on the remote host, and wait for him to read with with Elm.

Solution : https://rhn.redhat.com/errata/RHSA-2004-009.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the elmelm  package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"elm-2.5.6-4", release:"RHEL2.1") )
	security_hole(0);

