#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12450);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0542");
 name["english"] = "RHSA-2004-015: Apache";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Apache package installed.

The Apache HTTP server is vulnerable to various issues which
may allow an attacker with a local account to execute arbitrary code
with the privileges of the HTTP server by supplying a malformed .htaccess
file to it.

Solution : https://rhn.redhat.com/errata/RHSA-2004-015.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", prefix:"(httpd|mod_ssl)-", reference:"httpd-2.0.46-26.ent", yank:"ent") )
	security_hole(0);
else if ( rpm_exists(rpm:"httpd-", release:"RHEL3") ) set_kb_item(name:"CAN-2003-0542", value:TRUE);
