#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12452);
 script_bugtraq_id(9620);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0991");
 name["english"] = "RHSA-2004-019: mailmain";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mailman package installed.

mailman is a mailing list manager. There is a denial of service vulnerability
in the remote version of this package which may allow an attacker to crash
this service by sending a carefully crafted email message to the mailman
daemon.

Solution : https://rhn.redhat.com/errata/RHSA-2004-019.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"mailman-2.0.13-5", release:"RHEL2.1") )
	security_warning(0);

