#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12453);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0935");
 name["english"] = "RHSA-2004-023: Net-SNMP";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Net-SNMP package installed.

The Net-SNMP package contains various SNMP tools. A bug in the remote
installation of Net-SNMP may allow an existing user/community to gain
access to the data in MIB ojects which were explicitely excluded from
their view.

For this flaw to be exploitable, the remote host would need to have
the snmpd daemon enabled.

Solution : https://rhn.redhat.com/errata/RHSA-2004-023.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the NetSNMP package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"net-snmp-", reference:"net-snmp-5.0.9-2.30E.1", yank:"E", release:"RHEL3") ) 
	security_hole(0);
