#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12454);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0924");
 name["english"] = "RHSA-2004-041: NetPBM";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the NetPBM package installed.

NetPBM is a package which contains a library of functions which 
support program designed to manipulate various graphics file formats.

A number of bugs have been found in this library, which may allow
an attacker to execute arbitrary code on this host. To exploit these
flaws, an attacker would need to send a malformed graphic file to a user
of the remote host, and have this user open it with a program based on NetPBM.

Solution : https://rhn.redhat.com/errata/RHSA-2004-031.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the slocate package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", prefix:"netpbm-", reference:"netpbm-9.24-9.AS21.3", yank:"AS") ||
     rpm_check(release:"RHEL3", prefix:"netpbm-", reference:"netpbm-9.24-11.30.1") )
	security_hole(0);
