#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12456);
 script_bugtraq_id(8658);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-1023");
 name["english"] = "RHSA-2004-035: mc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mc package installed.

mc (Midnight Commander) is a text-based file manager. There is a bug in the
remote version of this software in the way it resolves symbolic links within
a file archive (tar or cpio).

An attacker could exploit this flaw to execute arbitrary code on the remote
host by sending a specially crafted tar or cpio archive to a victim on the
remote host and wait for him to process it using mc.

Solution : https://rhn.redhat.com/errata/RHSA-2004-035.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"(mc|gmc|mcserv)-", reference:"mc-4.5.51-36.1", release:"RHEL2.1") )
	security_hole(0);

