#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12457);
 script_bugtraq_id(6676, 8780);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0056", "CAN-2003-0848");
 name["english"] = "RHSA-2004-041: slocate";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the slocate package installed.

slocate, a program designed to find files on a system using a central
database, is vulnerable to a bug when the program parses a database.

A local user could exploit this vulnerability to gain 'slocate' 
group privilege, by crafting a specially malformed database and feeding
slocate with it.

Solution : https://rhn.redhat.com/errata/RHSA-2004-041.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the slocate package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check ( release:"RHEL2.1", reference:"slocate-2.7-1" ) ||
     rpm_check ( release:"RHEL3",   reference:"slocate-2.7-3" ) )
	security_warning(0);
