#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12458);
 script_bugtraq_id(5985, 9570);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2002-1574", "CAN-2003-0700", "CAN-2004-0003");
 name["english"] = "RHSA-2004-044: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel installed

The remote version of the kernel contains the following three security
vulnerabilities :

- The R128 Direct Render infrastructure (DRI) contains a bug which may
allow a local user to escalate privileges

- The C-Media PCI sound driver do not use the get_user() function properly

- There is an overflow in the ixj telephone card driver which may allow a local
user to get kernel-level privileges

Solution : https://rhn.redhat.com/errata/RHSA-2004-044.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"kernel-", reference:"kernel-2.4.9-e.37", release:"RHEL2.1") )
	security_hole(0);

