#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12460);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0097");
 name["english"] = "RHSA-2004-047: PWLib";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the PWLib package installed.

The PWLib is a cross platform library used by the OpenH323 project.

There are various flaws in the remote PWLib which may allow an attacker
to execute arbitrary code on the remote host, or to disable the remote
H.323 server/client by sending malformed H.323 packets to the remote H.323 
client or server.

Solution : https://rhn.redhat.com/errata/RHSA-2004-047.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PWLib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check(reference:"pwlib-1.4.7-7.EL", yank:"EL", release:"RHEL3") ) 
	security_hole(0);
