#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12461);
 script_bugtraq_id(9641);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0078");
 name["english"] = "RHSA-2004-050: mutt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mutt package installed.

mutt is a text-mode mail user agent. There is a flaw in the index menu
code of this program which may allow an attacker to execute arbitrary
code on the remote host.

To exploit this flaw, an attacker would need to send a specially malformed
email message to a mutt user of this host, and wait for him to display
it in his mailbox. 

Solution : https://rhn.redhat.com/errata/RHSA-2004-050.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"mutt-1.4.1-3.4", release:"RHEL3" ) ) security_hole(0);
