#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12462);
 script_bugtraq_id(9838, 9844);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0107", "CAN-2004-0108");
 name["english"] = "RHSA-2004-053: sysstat";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the sysstat and isag packages installed.

sysstat is a tool to gather system statistics, and isag is a tool to
graphically display these statistics.

A bug was found in the sysstat package post and trigger scripts, which
use insecure temporary file names. A local attacker could exploit this
problem to overflow system files using carefully-crafted symbolic links
in the /tmp directory.

The isag utility is also vulnerable to the same problem.

Solution : https://rhn.redhat.com/errata/RHSA-2004-053.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sysstat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"sysstat-", reference:"sysstat-4.0.1-12", release:"RHEL2.1") ||
     rpm_check(prefix:"sysstat-", reference:"sysstat-4.0.7-4.EL3.2", yank:"EL", release:"RHEL3") ) 
	security_hole(0);
