#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12463);
 script_bugtraq_id(9558);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0080");
 name["english"] = "RHSA-2004-056: util-linux";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the util-linux package installed
(older than util-linux-2.11f-20.4).

There is a potential information leakage in the remote version of this package
which may allow a local or remote attacker to obtain information such as
logins used, passwords, or anything else in memory.

Solution : https://rhn.redhat.com/errata/RHSA-2004-056.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util-linux package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"util-linux-2.11f-20.4", yank:"f", release:"RHEL2.1") )
	security_warning(0);

