#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12464);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0973");
 name["english"] = "RHSA-2004-058: mod_python";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mod_python package installed.

mod_python is an embeded python interpreter for the Apache webserver.
There is a vulnerability in the remote version of mod_python which
may allow an attacker to disable the remote web server remotely, provided
it's running.

Solution : https://rhn.redhat.com/errata/RHSA-2004-058.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"mod_python-2.7.8-2", release:"RHEL2.1") ||
     rpm_check(reference:"mod_python-3.0.3-3.ent", yank:"ent", release:"RHEL3") ) 
	security_warning(0);
