#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12465);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0083", "CAN-2004-0084", "CAN-2004-0106");
 name["english"] = "RHSA-2004-060: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the XFree86 package installed
(older than XFree86-4.1.0-56.EL).

There is a flaw in the remote version of this software which may allow a local
user to obtain root privileges by creating a carefully crafted 'font.alias'
file.

Solution : https://rhn.redhat.com/errata/RHSA-2004-060.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"XFree86-", reference:"XFree86-4.1.0-56.EL", yank:"EL", release:"RHEL2.1") )
	security_hole(0);

