#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12466);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0083", "CAN-2004-0084", "CAN-2004-0106");
 name["english"] = "RHSA-2004-061: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the XFree86 package installed.

The remote version of XFree86 is vulnerable to a privilege escalation
vulnerability which may allow a local user to gain superuser privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2004-061.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"XFree86-", reference:"XFree86-4.3.0-55.EL", yank:"EL", release:"RHEL3") ) 
	security_hole(0);
