#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12467);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0082");
 name["english"] = "RHSA-2004-064: Samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Samba package installed.

Samba provides file and printer sharing services to SMB/CIFS clients.
There is a bug in the remote Samba package. When an account for a user
is created but marked as disabled by the mksmbpasswrd script, Samba
may overwrite the user password with the contents of an un-initialized buffer,
which in turn may lead to a disabled account becoming enabled with a password
that can be guessed by an attacker.

Solution : https://rhn.redhat.com/errata/RHSA-2004-064.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"samba-", reference:"samba-3.0.2-6.3E", yank:"E", release:"RHEL3") ) security_warning(0);
