#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12470);
 script_bugtraq_id(9813);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0154");
 name["english"] = "RHSA-2004-072: nfs-utils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the nfs-utils package installed.

nfs-utils contains the rpc.mountd program, which implements the NFS mount
protocol.

A flaw was discovered in the installed version of rpc.mountd which may allow
an attacker to make rpc.mountd crash. To do so, an attacker would need
to ability to mount remote directories and have the control of a rogue server.

Solution : https://rhn.redhat.com/errata/RHSA-2004-072.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sysstat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", reference:"nfs-utils-1.0.6-7.EL", yank:"EL") ) security_hole(0); 
