#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12471);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0104", "CAN-2004-0105");
 name["english"] = "RHSA-2004-073: Metamail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Metamail package installed.

metamail is an implementation of MIME and is used by various utilities.
There is a bug in the remote version of this software which may allow an 
attacker to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to send a specially crafted 
email message which would be processed by metamail.


Solution : https://rhn.redhat.com/errata/RHSA-2004-073.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the metamail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check ( reference:"metamail-2.7-29", release:"RHEL2.1") ) security_hole(0);
