#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12472);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0592");
 name["english"] = "RHSA-2004-074: kdelibs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the kdelibs package installed.

This package contains a flaw in the way cookies are handled. An attacker may
exploit this flaw to gain access to cookies he should not have access to.

To exploit this flaw, an attacker would need to set up a rogue website and
lure a victim on the remote host to visit it.

Solution : https://rhn.redhat.com/errata/RHSA-2004-074.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdelibs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"(kdelibs|arts)-", reference:"kdelibs-2.2.2-10", release:"RHEL2.1"))
	security_hole(0);

