#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12473);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0113");
 name["english"] = "RHSA-2004-084: Apache / mod_ssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the httpd package installed.

There is a security issue in mod_ssl which may allow a denial of
service attack against an SSL-enabled server. An attacker could abuse
this problem to disable the remote web server (if enabled with https)
remotely.

Solution : https://rhn.redhat.com/errata/RHSA-2004-084.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"(httpd|mod_ssl)-", 
               release:"RHEL3", 
	       reference:"httpd-2.0.46-32.ent", 
               yank:"ent") ) security_hole(0);

