#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12474);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0110");
 name["english"] = "RHSA-2004-090: libxml2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the libxml2 package installed.

libxml2 is a library for manipulating XML files. There is a flaw in
this software which may allow an attacker to execute arbitrary code
on this host.

To exploit this flaw, an attacker would need to set up a rogue website
and get a user using a libxml2 enabled application to visit it.

Solution : https://rhn.redhat.com/errata/RHSA-2004-090.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"libxml2-", release:"RHEL2.1", reference:"libxml2-2.4.19-5.ent", yank:"ent") ||
     rpm_check(prefix:"libxml2-", release:"RHEL3", reference:"libxml2-2.5.10-6") )
	security_hole(0);
