#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12476);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0111");
 name["english"] = "RHSA-2004-103: gdk-pixbuf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the gdk-pixbuf package installed.

gdk-pixbuf is an image loading library, used with the GNOME Desktop Environment.

There is a bug in this software which my allow an attacker to make gdk-pixbuf
enabled applications to crash. To do so, an attacker would need to send a
specially malformed BMP file to a remote user.

Solution : https://rhn.redhat.com/errata/RHSA-2004-103.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gdk-pixbuf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check ( prefix:"gdk-pixbuf-", reference:"gdk-pixbuf-0.22.0-6.0.3", release:"RHEL2.1") ||
     rpm_check ( prefix:"gdk-pixbuf-", reference:"gdk-pixbuf-0.22.0-6.1.1", release:"RHEL3") )
	security_warning(0);
