#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12477);
 script_bugtraq_id(10141);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0109");
 name["english"] = "RHSA-2004-105: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel package installed
(older than kernel-2.4.9-e.40).

The remote Linux Kernel, which handles the basic functions of the operating 
system contains a potential buffer overflow in the iso9660 driver which
may allow a local user to obtain kernel-level privileges by inserting a CDROM 
with a specially crafted filesystem in the remote host (or by mounting a 
malformed ISO image of it).

Solution : https://rhn.redhat.com/errata/RHSA-2004-105.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"kernel-", reference:"kernel-2.4.9-e.40", yank:"e.", release:"RHEL2.1") )
	security_hole(0);

