#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12478);
 script_bugtraq_id(8981, 9323);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0564", "CAN-2003-0594");
 name["english"] = "RHSA-2004-110: Mozilla";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Mozilla package installed.

Mozilla, a web browser and mail reader, contains a bug in the way it handles
ASN.1 constructs in S/MIME data, which can cause Mozilla to crash or consume
large amounts of memory (which in turn may result in a denial of service
of the remote host).

An attacker may exploit this flaw by sending a specially malformed S/MIME 
message to a user of the remote host.

Mozilla also contains two security issues :

- A cross-site scripting issue
- A rogue website may fool Mozilla and make it send cookies it should not
  have access to.

Solution : https://rhn.redhat.com/errata/RHSA-2004-110.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", prefix:"mozilla-", reference:"mozilla-1.4.2-2.1.0") ||
     rpm_check(release:"RHEL2.1", prefix:"galeon-",  reference:"galeon-1.2.13-0.2.1") ||
     rpm_check(release:"RHEL3",   prefix:"mozilla-", reference:"mozilla-1.4.2-3.0") ) 
		security_hole(0);
