#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12479);
 script_bugtraq_id(8970);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0851", "CAN-2004-0081");
 name["english"] = "RHSA-2004-119: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenSSL package installed.

The OpenSSL toolkit implements SSLv2, SSLv3 and the TLSv1 protocols, and is
used by many applications.

There is a bug in the remote OpenSSL toolkit which may allow an attacker
to disable any SSL-related service remotely, by sending a carefully crafted
SSL/TLS handshake.

Solution : https://rhn.redhat.com/errata/RHSA-2004-119.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", prefix:"openssl-", reference:"openssl-0.9.6b-36") ||
     rpm_check(release:"RHEL2.1", prefix:"openssl096-", reference:"openssl096-0.9.6-25.7") ||
     rpm_check(release:"RHEL2.1", prefix:"openssl095-", reference:"openssl095-0.9.5a-24") )
	security_hole(0);
else if (rpm_exists(release:"RHEL2.1", rpm:"openssl") ) 
	set_kb_item(name:"CAN-2004-0081", value:TRUE);
