#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12480);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0079", "CAN-2004-0081", "CAN-2004-0112");
 name["english"] = "RHSA-2004-120: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenSSL package installed.

The OpenSSL toolkit implements SSLv2, SSLv3 and the TLSv1 protocols, and is
used by many applications.

There is a bug in the remote OpenSSL toolkit which may allow an attacker
to disable any SSL-related service remotely, by sending a carefully crafted
SSL/TLS handshake.


Solution : https://rhn.redhat.com/errata/RHSA-2004-120.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", prefix:"openssl-", reference:"openssl-0.9.7a-33.4") ||
     rpm_check(release:"RHEL3", prefix:"openssl096b-", reference:"openssl096b-0.9.6b-16") )
	security_hole(0);
else if (rpm_exists(release:"RHEL3", rpm:"openssl") )
	set_kb_item(name:"CAN-2004-0081", value:"TRUE");
