#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12481);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0189");
 name["english"] = "RHSA-2004-133: Squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Squid package installed.

Squid is a Web proxy cache. There is a bug in the remote version of this
package in the way it processes %-encoded characters in URL, which may
allow an attacker to evade Squid's access control lists (ACLs) in order
to get access to web server he should not have access to.

Solution : https://rhn.redhat.com/errata/RHSA-2004-133.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(release:"RHEL2.1", reference:"squid-2.4.STABLE6-10.21as", yank:"STABLE") ||
     rpm_check(release:"RHEL3", reference:"squid-2.5.STABLE3-5.3E", yank:"STABLE") ) 
	security_warning(0);
