#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12483);
 script_bugtraq_id(9701);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0093", "CAN-2004-0094");
 name["english"] = "RHSA-2004-152: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the XFree86 package installed
(older than XFree86-4.1.0-58.EL).

There is a flaw in the remote version of this software which may allow a local
or remote attacker with the ability to connect to the X server to cause a denial
of service by sending an out of bound array index when using the GLX extension
and DRI.

Solution : https://rhn.redhat.com/errata/RHSA-2004-152.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"XFree86-", reference:"XFree86-4.1.0-58.EL", yank:"EL", release:"RHEL2.1") )
	security_warning(0);

