#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12484);
 script_bugtraq_id(10138);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0180", "CAN-2004-0405");
 name["english"] = "RHSA-2004-153: cvs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the cvs package installed.

cvs is a version control system. There are two flaws in the remote package:

- On the client side, the cvs client contains a bug which may allow a rogue
cvs server to overwrite or create arbitrary files on this host. To exploit
this flaw, an attacker would need to lure a user of this host to connect
to his rogue cvs server.

- On the server side, a CVS pserver may be abused to view the content
of certain files outside of the CVS root directory, by using relative pathnames
containing '../'.

Solution : https://rhn.redhat.com/errata/RHSA-2004-153.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cvs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", reference:"cvs-1.11.1p1-12") ||
     rpm_check(release:"RHEL3",   reference:"cvs-1.11.2-18") )
	security_hole(0);
