#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12485);
 script_bugtraq_id(10147);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0182");
 name["english"] = "RHSA-2004-156: mailman";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mailman package installed
(older than 2.0.13-6).

Mailman is a mailing list manager. There is a flaw in the remote version
of this software which may allow an attacker to crash by sending a specially
crafted email destined for a list with an empty subject field.

Solution : https://rhn.redhat.com/errata/RHSA-2004-156.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"mailman-2.0.13-6", release:"RHEL2.1") )
	security_warning(0);

