#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12487);
 script_bugtraq_id(9713);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0160");
 name["english"] = "RHSA-2004-179: OpenOffice";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenOffice package installed.

OpenOffice.org is an office productivity suite. There is number of format
string issues in the neon client library that is used by OpenOffice.org which 
may allow an attacker to execute arbitrary code on this host. To exploit
this vulnerability, an attacker would need to create a malicious WebDAV
server and lure a user of the remote host into connecting to it using
OpenOffice.

Solution : https://rhn.redhat.com/errata/RHSA-2004-160.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenOffice package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", prefix:"openoffice\.org-", reference:"openoffice.org-1.1.0-15.EL", yank:"EL") )
	security_hole(0);
