#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12488);
 script_bugtraq_id(10072, 10172);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0155", "CAN-2004-0164", "CAN-2004-0403");
 name["english"] = "RHSA-2004-165: ipsec-tools";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the ipsec-tools package installed.

IPSEC is an extension to the IP protocol to provide both authentication
and encryption services.  ipsec-tools is a package used by RH Linux
to configure IPSEC services.

There are various bugs in the ipsec-tools package installed on the remote host:

- An attacker may be able to cause unauthorized deletion of Security 
Associations (SA) which may result in denial of service or which may
possibly cause network traffic to be retransmitted in clear-text.

- The RSA signature on x.509 certificates is not properly verified when
using certificate-based authentication. 

- It is possible to disable the remote 'racoon' daemon by sending a ISAKMP
header advertising a too long packet length, thus forcing the daemon
to allocate a huge amount of memory and potentially terminating the service
(and eventually the whole operating system).

Solution : https://rhn.redhat.com/errata/RHSA-2004-165.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ipsec-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", reference:"ipsec-tools-0.2.5-0.4", prefix:"ipsec-tools-") ) 
	security_hole(0);
