#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12489);
 script_bugtraq_id(10242);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0226", "CAN-2004-0231", "CAN-2004-0232");
 name["english"] = "RHSA-2004-172: mc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Midnight Commander (mc) package 
installed.

mc (Midnight Commander) is a text-based file manager. There are multiple
issues in this version of this software (buffer overflows, insecure temporary
file handling and format string issues) which may be exploited by a local
attacker to escalate his privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2004-172.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"(mc|gmc|mcserv)-", reference:"mc-4.5.51-36.3", release:"RHEL2.1") )
	security_hole(0);

