#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12490);
 script_bugtraq_id(10178);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0233");
 name["english"] = "RHSA-2004-174: utempter";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the utempter package installed.

utempter is a utility that allows terminal applications such as xterm
or screen to update the utmp and wtmp files without requiring root 
privileges.

There is a flaw in utempter which may allow a local attacker to overwrite
privileged files using a symlink.

Solution : https://rhn.redhat.com/errata/RHSA-2004-174.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the utempter package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"utempter-0.5.5-1.2.1EL.0", yank:"EL", release:"RHEL2.1") ||
     rpm_check( reference:"utempter-0.5.5-1.3EL.0", yank:"EL",   release:"RHEL3") ) 
	security_hole(0);
