#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12491);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0234", "CAN-2004-0235");
 name["english"] = "RHSA-2004-178: LHA";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the LHA package installed.

LHA is an archiving and compression utility for LHarc format archives.

There is a couple of stack overflows and directory traversal flaws in the
remote LHA utility. An attacker could exploit these to execute arbitrary
code on this host by sending a carefully crafter LHA archive to a user of the
remote host and wait for him to uncompress the archive.

Solution : https://rhn.redhat.com/errata/RHSA-2004-178.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the LHA package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", reference:"lha-1.00-17.2") ||
     rpm_check(release:"RHEL3",   reference:"lha-1.14i-10.2") )
 	security_hole(0);
