#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12492);
 script_bugtraq_id(10244);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0421");
 name["english"] = "RHSA-2004-180: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the libpng package installed.

libpng is a package which contains a library of functions which 
support program designed to manipulate the PNG file format.

There is a bug in the remote version of libpng which may allow an
attacker to make libpng-enabled program to crash when reading
a specially malformed .png file.


Solution : https://rhn.redhat.com/errata/RHSA-2004-180.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"libpng-", release:"RHEL2.1",  reference:"libpng-1.0.14-0.7x.5", yank:"x") ||
     rpm_check(prefix:"libpng-", release:"RHEL3",  reference:"libpng-1.2.2-21" ) ) 
	security_warning(0);
