#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12493);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0109", "CAN-2004-0424");
 name["english"] = "RHSA-2004-183: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel package installed.

The remote Linux Kernel, which handles the basic functions of the operating 
system, contains a bug in the ip_setsockopt() function which may allow a local
user to gain superuser privileges. It also contains a buffer overflow bug
in the ISO9660 filsystem code, which may allow a user to gain root privileges
by making the remote host read a malformed CD-ROM or local loopback file.

Solution : https://rhn.redhat.com/errata/RHSA-2004-183.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"kernel-", release:"RHEL3", reference:"kernel-2.4.21-9.0.3.EL", yank:"EL"))
	security_hole(0);
