#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12494);
 script_bugtraq_id(10330, 10331, 9154, 9570, 9691);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0461", "CAN-2003-0465", "CAN-2003-0984", "CAN-2004-0003", "CAN-2004-0010");
 name["english"] = "RHSA-2004-188: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel package installed.

The remote Linux Kernel, which handles the basic functions of the operating 
system contains several security issues :

- /proc/tty/driver/serial reveals the exact character counts for serial
links. An attacker could abuse this problem to guess which commands
are issued over a serial link, or even to guess the length of the 
passwords of users using the serial link.

- The kernel strncpy() function do not pad the target buffer with null bytes
on non-x86 architectures, which can lead to information leaks

- A minor data leak exists in /dev/rtc

- A flaw in the R128 DRI infrastructure may allow a local user to gain
super-user privileges

- A flaw in ncp_lookup() in ncpfs may allow a local user to gain super-user
privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2004-188.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(prefix:"kernel-", release:"RHEL3", reference:"kernel-2.4.21-15.EL", yank:"EL") ) security_hole(0);
